unit Common;


interface

uses Windows, SysUtils, Contnrs, Classes, Math, dialogs, Graphics;

type
  TFigure = (square, circle, triup, tridown);

  // speichert beleibig viele Integer/Cardinal-Werte
  TIntArray = Array of Integer;
  TCardinalArray = Array of Cardinal;

  // Frs Speichern des BC-Arrays
  TBC_IntArray = Array[Char] of Integer;
  TBC_CardinalArray = Array[Char] of Cardinal;   // fr Shift-And/-Or, BNDM
  TBC_Int64Array = Array[Char] of Int64;         // fr Shift-And/-Or, BNDM bei lngeren Mustern (bis 62)


  TBOM_Oracle = Array of TBC_IntArray;

  TMultiTrefferList = TObjectlist;
  TSimpleTrefferList = TList;
  TApproxTrefferList = TObjectlist;

  TTreffer = class
      Index: Integer;    // Index des gefunden Musters in der Musterliste
      Position: Integer; // Position des Musters im Text
      constructor Create(idx,p: Integer);
  end;

  TApproxTreffer = class
      Index: Integer;    // Index des gefunden Musters in der Musterliste
      Error: Integer; // Fehler bei diesem Vorkommen
      constructor Create(idx,k: Integer);
  end;

  function SimpleTrefferAreEqual(t1, t2: TSimpleTrefferList): Boolean;

  function TrefferSort(Item1, Item2: Pointer): Integer;
  function MultiTrefferAreEqual(t1, t2: TMultiTrefferList): Boolean;

  function ApproxTrefferAreEqual(t1, t2: TApproxTrefferList): Boolean;


// Generiert einen String der Lnge aLength ber einem Alphabet der Gre Sigma
function GenerateRandomString(aLength: Integer; Sigma: Integer): String;

function SekToZeitString(dauer:int64; OnlyMinutes: Boolean = False):string;
function TextSizeToString(aSize: Int64): String;

procedure SortedInsert(aList: TList; aValue: Integer);

Function GetMedian(aList: TList): Integer;

procedure DrawDot(aCanvas: tCanvas; X,Y: Integer; fig: TFigure; Col: TColor);

function TextSizeToFilename(aValue: Integer):String;

implementation

function SimpleTrefferAreEqual(t1, t2: TSimpleTrefferList): Boolean;
var i: Integer;
begin
  // beide da oder beide nicht da
  result := (assigned(t1) and assigned(t2)) or ((not assigned(t1)) and (not assigned(t2)));

  if not assigned(t1) then exit;

  if result  then // beide da, Lnge testen
    result := t1.Count = t2.Count;
    
  // Lnge gleich, echter test:
  if result  then
    for i := 0 to t1.Count - 1 do
    begin
        if Integer(t1[i]) <> Integer(t2[i]) then
        begin
            result := false;
            break;
        end;
    end;
end;

constructor TTreffer.Create(idx,p: Integer);
begin
  inherited create;
  Index := Idx;
  Position := p;
end;

constructor TApproxTreffer.Create(idx,k: Integer);
begin
  inherited create;
  Index := Idx;
  Error := k;
end;

function TrefferSort(Item1, Item2: Pointer): Integer;
var tmp: integer;
begin
  tmp := CompareValue(TTreffer(Item1).Position, tTreffer(Item2).Position);
  if tmp = 0 then
    result := CompareValue(TTreffer(Item1).Index, tTreffer(Item2).Index)
  else
    result := tmp;
end;

function MultiTrefferAreEqual(t1, t2: TMultiTrefferList): Boolean;
var i: Integer;
begin
  // beide da oder beide nicht da
  result := (assigned(t1) and assigned(t2)) or ((not assigned(t1)) and (not assigned(t2)));

  if not assigned(t1) then exit;

  if result  then // beide da, Lnge testen
    result := t1.Count = t2.Count;

  // Lnge gleich, echter test:
  if result  then
    for i := 0 to t1.Count - 1 do
    begin
        if (TTreffer(t1[i]).Index <> TTreffer(t2[i]).Index)
          or (TTreffer(t1[i]).Position <> TTreffer(t2[i]).Position) then
        begin
            result := false;
            break;
        end;
    end;
end;

function ApproxTrefferAreEqual(t1, t2: TApproxTrefferList): Boolean;
var i: Integer;
begin
  // beide da oder beide nicht da
  result := (assigned(t1) and assigned(t2)) or ((not assigned(t1)) and (not assigned(t2)));

  if not assigned(t1) then exit;

  if result  then // beide da, Lnge testen
    result := t1.Count = t2.Count;
  // Lnge gleich, echter test:
  if result  then
    for i := 0 to t1.Count - 1 do
    begin
        if (TApproxTreffer(t1[i]).Index <> TApproxTreffer(t2[i]).Index)
          or (TApproxTreffer(t1[i]).Error <> TApproxTreffer(t2[i]).Error) then
        begin
            result := false;
            break;
        end;
    end;
end;


function GenerateRandomString(aLength: Integer; Sigma: Integer): String;
var i: Integer;
begin
  setlength(result, aLength);
  if Sigma <= 150 then
      for i := 1 to length(result) do
        result[i] := Chr(Random(Sigma) + ord('A'))
  else
      for i := 1 to length(result) do
        result[i] := Chr(Random(Sigma) + 2)
end;


function SekToZeitString(dauer:int64; OnlyMinutes: Boolean = False):string;
var sek,min,std,tag:integer;
  d:integer;
begin
  result := '';
  d := 0;
  // sekunden rausrechnen
  sek := dauer mod 60;
  dauer := dauer div 60;
  if dauer > 0 then inc(d); // nur sekunden

  // minuten rausrechnen
  min := dauer mod 60;
  dauer := dauer DIV 60;
  if dauer > 0 then inc(d); //  min:sek

  // Stunden ausrechnen
  std := dauer mod 24;
  dauer := dauer DIV 24;
  if dauer > 0 then inc(d); // std:min

  tag := dauer;

  case d of
    0: {nur Sekunden} result := Format('%d %s', [sek, 'Sekunde(n)']);
    1: if OnlyMinutes then
          result := Format('%.2d %s', [min, 'Minuten'])
       else
          result := Format('%d %s, %.2d %s', [min, 'Minute(n)', sek, 'Sekunde(n)']);
    2: result := Format('%d %s, %.2d %s', [std, 'Stunde(n)', min, 'Minute(n)']);

    3:  if tag <= 3 then
          result := Format('%d %s', [24 * tag + std, 'Stunden'])
        else
          result :=  Format('%d %s', [tag, 'Tage']);
  end;
end;

function TextSizeToString(aSize: Int64): String;
begin
    if aSize<=1024 then
      result := inttostr(aSize) + ' Byte; '
    else if aSize<=1024*1024 then
      result :=  FloatToStrF((aSize / 1024),ffFixed,4,0) + ' KiB; '
        else if aSize<=1024*1024*1024 then
          result := FloatToStrF((aSize / 1024 / 1024),ffFixed,8,0) + ' MiB; '
          else
            result := FloatToStrF((aSize / 1024 / 1024 / 1024),ffFixed,4,0) + ' GiB; ';
end;

procedure SortedInsert(aList: TList; aValue: Integer);
var i: Integer;
begin
  if aList.Count = 0 then
    aList.Add(Pointer(aValue))
  else
  begin
      i := 0;
      while (i < aList.Count) and (Integer(aList[i]) < aValue) do
        inc(i);
      aList.Insert(i, Pointer(aValue));
  end;
end;

Function GetMedian(aList: TList): Integer;
begin
  case aList.Count of
      0: result := 0
      else result := Integer(aList[aList.Count div 2])
  end;
end;

procedure DrawDot(aCanvas: tCanvas; X,Y: Integer; fig: TFigure; Col: TColor);
var oldBrushCol: TColor;
    oldPenCol: TColor;
begin
    oldBrushCol := aCanvas.Brush.Color;
    oldPenCol := aCanvas.Pen.Color;

    aCanvas.Pen.Color := Col;
    aCanvas.Brush.Color := Col;

    case fig of
        square : aCanvas.Rectangle(Rect(x-4,y-4,x+4,y+4));
        circle : aCanvas.Ellipse(x-4,y-4,x+4,y+4);
        triup  : aCanvas.Polygon([Point(x,y-4), Point(x+4,y+4), Point(x-4,y+4)]);
        tridown: aCanvas.Polygon([Point(x,y+4), Point(x+4,y-4), Point(x-4,y-4)]);
    end;
    aCanvas.MoveTo(x,y);

    aCanvas.Brush.Color := oldBrushCol  ;
    aCanvas.Pen.Color := oldPenCol;
end;

function TextSizeToFilename(aValue: Integer):String;
    begin
      case aValue  of
          10240     : result := '10kb';
          102400    : result := '100kb';
          1024*1024 : result := '1mb';
          1024*10240: result := '10mb';
          else        result := '50mb';
      end;
    end;

end.
